;            
;===============================================
;       NAME: 
;	PE-Header                          
;       IncludeFile 
;
;	Author:	metheus@gmx.net
;                      
;===============================================
;       DESCRIPTION:                              
;	nasm syntax
;
;===============================================
;	HISTORY:
;	08.08.98
;	-17.02.99 converted to nasm syntax
;	-23.06.99 added resource, debug and 
;		  load config directory
;	-25.07.99 added reloc directory
;===============================================
; 	   
;===============================================
;
;
;=======================================================================================
;
;	CONSTANTS	
;
;=======================================================================================
;
MZ_SIGNATURE     	EQU   	5A4Dh 		;'MZ'
PE_SIGNATURE      	EQU   	00004550h   	;'PE',0,0
PE_x86			EQU	014Ch		; 386 CPU type
;
;-----------------------------------------------
;	MZ Header
;-----------------------------------------------
;


STRUC	IMAGE_MZ_HEADER  
    	MZ_Magic      		resw    1	; Magic number
    	MZ_Cblp       		resw    1           ; Bytes on last page of file
    	MZ_cp         		resw    1           ; Pages in file
    	MZ_crlc       		resw    1           ; Relocations
    	MZ_cparhdr    		resw    1           ; Size of header in paragraphs
    	MZ_minalloc   		resw    1           ; Minimum extra paragraphs needed
    	MZ_maxalloc   		resw    1           ; Maximum extra paragraphs needed
    	MZ_ss         		resw    1           ; Initial (relative) SS value
    	MZ_sp         		resw    1           ; Initial SP value
    	MZ_csum       		resw    1           ; Checksum
    	MZ_ip         		resw    1           ; Initial IP value
    	MZ_cs         		resw    1           ; Initial (relative) CS value
    	MZ_lfarlc     		resw    1           ; File aresdress of relocation table
    	MZ_ovno       		resw    1           ; Overlay number
    	MZ_res        		resw	4	  ; Reserved words
    	MZ_oemid      		resw    1           ; OEM identifier (for e_oeminfo)
    	MZ_oeminfo    		resw    1           ; OEM information; e_oemid specific
    	MZ_res2       		resw	10 	  ; Reserved words
	MZ_PEHeaderBase   	resd    1           ; File aresdress of new exe header
ENDSTRUC

;
;-----------------------------------------------
;	PE Header
;-----------------------------------------------
;

STRUC 	IMAGE_PE_HEADER	
    	PE_HeaderSignature              resd    1
	PE_CPUType			resw	1
	PE_NumberOfObjects		resw	1
	PE_TimeDateStamp          	resd    1
    	PE_PointerToSymbolTable   	resd    1
    	PE_NumberOfSymbols        	resd    1
    	PE_NTHeaderSize   	  	resw    1
    	PE_Flags	        	resw    1
; NTHeader
	PE_Reserved1			resw	1
    	PE_MajorLinkerVersion           resb    1
    	PE_MinorLinkerVersion           resb    1
	PE_CodeSize			resd	1
	PE_InitializeresdataSize	resd	1
	PE_UninitializeresdataSize	resd	1
	PE_EntrypointRVA		resd	1
	PE_CodeBaseRVA			resd	1
	PE_DataBaseRVA			resd	1
; 0
    	PE_ImageBase                    resd    1
    	PE_ObjectAlignment              resd    1
    	PE_FileAlignment                resd    1
    	PE_OSMajor  			resw    1
    	PE_OSMinor  			resw    1
    	PE_UserMajor                    resw    1
    	PE_UserMinor                    resw    1
    	PE_SubsysMajor                  resw    1
    	PE_SubsysMinor                  resw    1
    	PE_Reserved5                    resd    1
    	PE_ImageSize                    resd    1
    	PE_HeaderSize                   resd    1
    	PE_FileChecksum                 resd    1
    	PE_Subsystem                    resw    1
    	PE_DllFlags                     resw    1
    	PE_StackReserveSize             resd    1
    	PE_StackCommitSize              resd    1
    	PE_HeapReserveSize              resd    1
    	PE_HeapCommitSize               resd    1
    	PE_LoaderFlags                  resd    1		;Undocumented	  	
    	PE_NumberOfRvaSizes             resd    1
	PE_ExportTableRVA		resd	1
	PE_TotalExportDataSize		resd	1
	PE_ImportTableRVA		resd	1
	PE_TotalImportDataSize		resd	1
	PE_ResoureTableRVA		resd	1
	PE_TotalResourceDataSize	resd	1
	PE_ExceptionTableRVA		resd	1
	PE_TotalExceptionDataSize	resd	1
	PE_SecurityTableRVA		resd	1
	PE_TotalSecurityDataSize	resd	1
	PE_RelocationTableRVA		resd	1
	PE_RelocationSize		resd	1
	PE_DebugDirectoriesRVA		resd	1
	PE_DebugDirectories		resd	1
	PE_ImageDescriptionRVA		resd	1		;Copyright
	PE_ImageDescriptionSize		resd	1
	PE_MachineSpecificRVA		resd	1		;Globalptr
	PE_MachineSpecificSize		resd	1
	PE_ThreadLocalStorageRVA	resd	1		
	PE_ThreadLocalStoragSize	resd	1
	PE_LoadConfigRVA		resd	1
	PE_LoadConfigSize		resd	1
	PE_BoundImportRVA		resd	1
	PE_BoundImportSize		resd	1
	PE_IATRVA			resd	1
	PE_IATSize			resd	1
ENDSTRUC

IMAGE_FILE_RELOCS_STRIPPED     EQU 0001h ; Relocation info stripped from file
IMAGE_FILE_EXECUTABLE_IMAGE    EQU 0002h ; File is executable  (i.e. no unresolved external references)
IMAGE_FILE_LINE_NUMS_STRIPPED  EQU 0004h ; Line numbers stripped from file
IMAGE_FILE_LOCAL_SYMS_STRIPPED EQU 0008h ; Local symbols stripped from file
;MAGE_FILE_MINIMAL_OBJECT      EQU 0010h ; Reserved
;MAGE_FILE_UPDATE_OBJECT       EQU 0020h ; Reserved
;MAGE_FILE_16BIT_MACHINE       EQU 0040h ; 16 bit word machine
IMAGE_FILE_BYTES_REVERSED_LO   EQU 0080h ; Bytes of machine word are reversed
IMAGE_FILE_32BIT_MACHINE       EQU 0100h ; 32 bit word machine
IMAGE_FILE_DEBUG_STRIPPED      EQU 0200h ; Debugging info stripped from file in .resbG file
;MAGE_FILE_PATCH               EQU 0400h ; Reserved
IMAGE_FILE_SYSTEM              EQU 1000h ; System File
IMAGE_FILE_DLL                 EQU 2000h ; File is a DLL
IMAGE_FILE_BYTES_REVERSED_HI   EQU 8000h ; Bytes of machine word are reversed

PE_MAX_NUMBER_RVAS		       EQU 20h	 ;Maximal number of RVA in PEHeader after PE_NumberOfRvaSizes
;
;-----------------------------------------------
;	Object Table
;-----------------------------------------------
;
STRUC 	IMAGE_OBJECT_TABLE	
	OT_ObjectName			resb	8
	OT_VirtualSize			resd	1
	OT_RVA				resd	1
	OT_PhysicalSize			resd	1
	OT_PhysicalOffset		resd	1
	OT_RelocationsRVA		resd	1
	OT_LinenumberRVA		resd	1	
	OT_NumberOfRelocations		resw	1
	OT_NumberOfLinenumbers		resw	1
	OT_ObjectFlags			resd	1
ENDSTRUC
 
OT_CODE_OBJECT				EQU	00000020h
OT_INITIALIZED_DATA			EQU	00000040h
OT_UNINITIALIZED_DATA			EQU	00000080h
OT_DISCARDABLE        			EQU  	02000000h 	
OT_OBJECT_NOT_CACHED			EQU	04000000h
OT_OBJECT_NOT_PAGEABLE			EQU	08000000h
OT_SHARED_OBJECT			EQU	10000000h	
OT_EXECUTEABLE				EQU	20000000h
OT_READABLE				EQU	40000000h
OT_WRITEABLE				EQU	80000000h

;
;-----------------------------------------------
;	Export Directory Table
;-----------------------------------------------
;
STRUC	IMAGE_EXPORT_DIRECTORY_TABLE		
	EDT_ExportFlags			resd	1
	EDT_TimeDateStamp		resd	1
	EDT_MajorVersion		resw	1
	EDT_MinorVersion		resw	1
	EDT_NameRVA			resd	1
	EDT_OrdinalBase			resd	1
	EDT_EATEntries			resd	1
	EDT_NamePtrs			resd	1
	EDT_AddressTableRVA		resd	1
	EDT_NamePtrTableRVA		resd	1
	EDT_OrdinalTableRVA		resd	1
ENDSTRUC
;
;-----------------------------------------------
;	Import Directory Table
;-----------------------------------------------
;
STRUC	IMAGE_IMPORT_DIRECTORY_TABLE		
	IDT_OriginalLookupTableRVA	resd	1	;untouched original lookupTable
	IDT_TimeDateStamp		resd	1
	IDT_MajorVersion		resw	1
	IDT_MinorVersion		resw	1
	IDT_NameRVA			resd	1
	IDT_PatchedLookupTableRVA	resd	1	;Copy of ImportLookupTable 0 
ENDSTRUC
;
;-----------------------------------------------
;	Debug Directory Table
;-----------------------------------------------
;
STRUC	IMAGE_DEBUG_DIRECTORY_TABLE		
	DDT_DebugFlags			resd	1	
	DDT_TimeDateStamp		resd	1
	DDT_MajorVersion		resw	1
	DDT_MinorVersion		resw	1
	DDT_DebugType			resd	1
	DDT_DataSize			resd	1	
	DDT_DataRVA			resd	1
	DDT_DataSeek			resd	1
ENDSTRUC
;
;-----------------------------------------------
;	Resource Directory Table
;-----------------------------------------------
;
STRUC	IMAGE_RESOURCE_DIRECTORY_TABLE		
	RDT_Flags			resd	1	
	RDT_TimeDateStamp		resd	1
	RDT_MajorVersion		resw	1
	RDT_MinorVersion		resw	1
	RDT_NumberOfNamedEntries	resw	1
	RDT_NumberOfIdEntries		resw	1	
ENDSTRUC
;
;-----------------------------------------------
;	Load Config Directory Table
;-----------------------------------------------
;
STRUC	IMAGE_BASE_RELOCATION
	BR_RVA				resd	1
	BR_SizeOfBlock			resd	1
ENDSTRUC

IMAGE_REL_BASED_ABSOLUTE        	EQU    	0
IMAGE_REL_BASED_HIGH            	EQU     1
IMAGE_REL_BASED_LOW             	EQU     2
IMAGE_REL_BASED_HIGHLOW         	EQU     3
IMAGE_REL_BASED_HIGHADJ         	EQU     4
IMAGE_REL_BASED_MIPS_JMPADDR    	EQU     5
IMAGE_REL_BASED_SECTION         	EQU     6
IMAGE_REL_BASED_REL32           	EQU     7

;
;-----------------------------------------------
;	Load Config Directory Table
;-----------------------------------------------
;
STRUC	IMAGE_LOAD_CONFIG_DIRECTORY		
	LDT_Flags			resd	1	
	LDT_TimeDateStamp		resd	1
	LDT_MajorVersion		resw	1
	LDT_MinorVersion		resw	1
	LDT_GlobalFlagsClear	resd	1
        LDT_GlobalFlagsSet		resd	1
        LDT_CriticalSectionDefaultTimeout resd	1
    	LDT_DeCommitFreeBlockThreshold	resd	1
    	LDT_DeCommitTotalFreeThreshold	resd	1
        LDT_LockPrefixTable		resd	1 	;!! Probably wrong length (PVOID ?)
    	LDT_MaximumAllocationSize	resd	1
    	LDT_VirtualMemoryThreshold	resd	1
    	LDT_ProcessHeapFlags		resd	1
    	LDT_ProcessAffinityMask		resd	1
    	LDT_Reserved			resd	3
ENDSTRUC